﻿using Hims.Shared.UserModels.Common;

namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Domain.Services;
    using Hims.Shared.UserModels.DynamicDashboard;
    using Hims.Shared.UserModels.DynamicDashboard.Config;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Shared.EntityModels;
    using Utilities;

    /// <inheritdoc />
    [Authorize]
    [Route("api/dynamic-dashboard")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class DynamicDashboardController : BaseController
    {

        /// <summary>
        /// The auditlog services.
        /// </summary>
        private readonly IAuditLogService auditLogServices;

        /// <summary>
        /// The admission services.
        /// </summary>
        private readonly IDynamicDashboardService dynamicDashboardService;

        /// <inheritdoc />
        public DynamicDashboardController(
            IAuditLogService auditLogServices,
            IDynamicDashboardService dynamicDashboardService)
        {
            
            this.auditLogServices = auditLogServices;
            this.dynamicDashboardService = dynamicDashboardService;
        }

        /// <summary>
        /// Inserts the asynchronous.
        /// The fetch widgets.
        /// </summary>
        /// <param name="model">
        /// The widget filter model.
        /// </param>
        /// <returns>
        /// The list of config.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of Widgets.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] FetchFilterModel model)
        {
            try
            {
                var widgets = await this.dynamicDashboardService.FetchAsync(model).ConfigureAwait(false);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = widgets
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The insert widget async.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("insert")]
        public async Task<ActionResult> InsertAsync([FromBody] InsertModel model)
        {
            try
            {
                var response = await this.dynamicDashboardService.InsertAsync(model).ConfigureAwait(false);

                //if (response.Status == GenericStatus.Success)
                //{
                //    var auditLogModel = new AuditLogModel
                //    {
                //        AccountId = model.CreatedBy,
                //        LogTypeId = (int)LogTypes.DashboardWidget,
                //        LogFrom = (short)model.LogFrom,
                //        LogDate = DateTime.UtcNow.AddMinutes(330),
                //        LogDescription = $@"{model.CreatedByName} has added a new widget '{model.Name}' on {DateTime.UtcNow.AddMinutes(330)}"
                //    };
                //    await this.auditLogServices.LogAsync(auditLogModel);
                //}

                return Ok(response);
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }

        /// <summary>
        /// The update widget async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        //[HttpPost]
        //[Route("update")]
        //public async Task<ActionResult> UpdateAsync([FromBody] DashboardConfigModel model)
        //{
        //    try
        //    {
        //        var response = await this.dynamicDashboardService.UpdateAsync(model).ConfigureAwait(false);

        //        //if (response > 0)
        //        //{
        //        //    var auditLogModel = new AuditLogModel
        //        //    {
        //        //        AccountId = model.ModifiedBy,
        //        //        LogTypeId = (int)LogTypes.DashboardWidget,
        //        //        LogFrom = (short)model.LogFrom,
        //        //        LogDate = DateTime.UtcNow.AddMinutes(330),
        //        //        LogDescription = $@"{model.ModifiedByName} has updated widget <br/>name: '{model.Name}'<br/>type: '{widgetTye}'<br/>stored procedure: '{model.StoredProcedureName}' on {DateTime.UtcNow.AddMinutes(330)}"
        //        //    };
        //        //    await this.auditLogServices.LogAsync(auditLogModel);
        //        //}

        //        return Ok(new GenericResponse
        //        {
        //            Status = response switch
        //            {
        //                -1 => GenericStatus.Error,
        //                -2 => GenericStatus.Info,
        //                _ => GenericStatus.Success
        //            },
        //            Data = response
        //        });
        //    }
        //    catch (Exception ex)
        //    {
        //        return Ok(new GenericResponse
        //        {
        //            Status = GenericStatus.Error,
        //            Message = ex.Message
        //        });
        //    }
        //}

        /// <summary>
        /// The deactivate widget async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Route("delete")]
        public async Task<ActionResult> DeleteAsync([FromBody] DeleteWidgetModel model)
        {
            try
            {
                var response = await this.dynamicDashboardService.DeleteAsync(model.DashboardConfigId);

                //if (response > 0)
                //{
                //    var auditLogModel = new AuditLogModel
                //    {
                //        AccountId = model.ModifiedBy,
                //        LogTypeId = (int)LogTypes.DashboardWidget,
                //        LogFrom = (short)model.LogFrom,
                //        LogDate = DateTime.UtcNow.AddMinutes(330),
                //        LogDescription = $@"{model.ModifiedByName} has deactivated widget <br/>'{model.Name}' on {DateTime.UtcNow.AddMinutes(330)}"
                //    };
                //    await this.auditLogServices.LogAsync(auditLogModel);
                //}

                return Ok(new GenericResponse
                {
                    Status = response ? GenericStatus.Success : GenericStatus.Error,
                    Data = response
                });
            }
            catch (Exception ex)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = ex.Message
                });
            }
        }
    }
}